Attribute VB_Name = "Module1"
Public Const EX_NONMATH As Integer = 0
Public Const EX_Overflow As Integer = 1
Public Const EX_Underflow As Integer = 2
Public Const EX_InvalidArgument As Integer = 3
Public Const EX_ZeroDivide As Integer = 4
Public Const EX_InvalidOp As Integer = 5

Public Const ERR_NOERROR As Integer = 0
Public Const ERR_NO_MATH_EXPRESSION_WAS_PARSED As Integer = -1
Public Const ERR_PARANTHESES_SYNTAX_ERROR As Integer = -2
Public Const ERR_INVALID_DERIVATIVE_VARIABLE_NAME As Integer = -3
Public Const ERR_MATH_EXPRESSION_IS_EMPTY As Integer = -4
Public Const ERR_IDENTIFIER_CANNOT_BE_EMPTY As Integer = -5
Public Const ERR_IDENTIFIER_LENGTH As Integer = -6
Public Const ERR_NOT_PASCAL_IDENTIFIER As Integer = -7
Public Const ERR_IDENTIFIER_CANNOT_BE_RESERVED_NAME As Integer = -8
Public Const ERR_IDENTIFIER_ALREADY_EXISTS As Integer = -9
Public Const ERR_DUBLICATING_USER_IDENTIFIER As Integer = -10
Public Const ERR_UNKNOWN_EXPRESSION As Integer = -11
Public Const ERR_BAD_EXPONENTIAL_FORMAT As Integer = -12
Public Const ERR_SET_OriginalMathExpressionString_FALSE As Integer = -13
Public Const ERR_MATH_EXPRESSION_WAS_ERASED As Integer = -14
Public Const ERR_USE_VerifySyntaxSemanticsAndDerivation As Integer = -15
Public Const ERR_DERIVATIVE_EXPRESSION_WAS_ERASED As Integer = -16
Public Const ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT As Integer = -17
Public Const ERR_MATH_EXPRESSIONS_ARRAY As Integer = -18
Public Const ERR_FUNCTION_NUMBER_MUST_BE_LESS As Integer = -19
Public Const ERR_FUNCTION_ADDRESS_CANNOT_BE_NIL As Integer = -20
Public Const ERR_PROTECTED_EXPRESSION As Integer = -21
Public Const ERR_PARSE As Integer = -22
Public Const ERR_EXECUTE As Integer = -23
Public Const ERR_DYNAMIC_MEMORY As Integer = -24
Public Const ERR_MULTIPLY As Integer = -25
Public Const ERR_DIVISION As Integer = -26
Public Const ERR_PLUS As Integer = -27
Public Const ERR_MINUS As Integer = -28
Public Const ERR_POWER As Integer = -29
Public Const ERR_EQUAL As Integer = -30
Public Const ERR_UNKNOWN_FUNCTION As Integer = -31
Public Const ERR_UNKNOWN_VARIABLE As Integer = -32
Public Const ERR_BAD_SYNTAX As Integer = -33
Public Const ERR_COMMA_SYNTAX As Integer = -34
Public Const ERR_SYSTEM_STACK_OVERFLOW As Integer = -35
Public Const ERR_DEF_FUNC_NAME As Integer = -36
Public Const ERR_DEF_FUNC_DUBLICATING As Integer = -37
Public Const ERR_DEF_FUNC_IMPLEMENTING As Integer = -38
Public Const ERR_DEF_FUNC_ARG_COUNT As Integer = -39
Public Const ERR_DEF_FUNC_ARG_NAME As Integer = -40
Public Const ERR_DEF_FUNC_ARG_DUBLICATING As Integer = -41
Public Const ERR_DEF_FUNCTION_STACK_OVERFLOW As Integer = -42

Function ParseErrorMesssage(ByRef MyObj As Object, ByVal Item As Integer) As String
 Dim s, s1 As String, i As Integer

  i = InStr(MyObj.ErrorMessageInfo(Item), ":")
  If i > 0 Then
   s1 = " : " + Mid(MyObj.ErrorMessageInfo(Item), i + 1, Len(MyObj.ErrorMessageInfo(Item)) - i)
  Else
   s1 = ""
  End If
  If Len(s1) > 256 Then
   s1 = Mid(s1, 1, 256)
  End If
  
  s1 = LCase(s1)
  s = ""
  Select Case MyObj.MathException(Item)
   Case EX_NONMATH
       s = " : NONMATH"
   Case EX_Overflow
       s = " : Overflow"
   Case EX_Underflow
       s = " : Underflow"
   Case EX_InvalidArgument
       s = " : InvalidArgument"
   Case EX_ZeroDivide
       s = " : ZeroDivide"
   Case EX_InvalidOp
       s = " : InvalidOp"
  End Select

Select Case MyObj.ErrorNumber(Item)
 Case ERR_PARSE
       ParseErrorMesssage = "Invalid expression" + s1
 Case ERR_BAD_SYNTAX
       ParseErrorMesssage = "Syntax error" + s1
 Case ERR_COMMA_SYNTAX
       ParseErrorMesssage = "Comma syntax error" + s1
 Case ERR_NO_MATH_EXPRESSION_WAS_PARSED
       ParseErrorMesssage = "No math expression was parsed"
 Case ERR_PARANTHESES_SYNTAX_ERROR
       ParseErrorMesssage = "Mismatched parenthesis"
 Case ERR_INVALID_DERIVATIVE_VARIABLE_NAME
       ParseErrorMesssage = "Invalid name of derivative variable" + s1
 Case ERR_MATH_EXPRESSION_IS_EMPTY
       ParseErrorMesssage = "Mathematical expression is empty"
 Case ERR_IDENTIFIER_CANNOT_BE_EMPTY
       ParseErrorMesssage = "Identifier cannot be empty"
 Case ERR_IDENTIFIER_LENGTH
       ParseErrorMesssage = "Identifier length is too long" + s1
 Case ERR_NOT_PASCAL_IDENTIFIER
       ParseErrorMesssage = "Invalid identifier" + s1
 Case ERR_IDENTIFIER_CANNOT_BE_RESERVED_NAME
       ParseErrorMesssage = "Identifier cannot be a reserved name" + s1
 Case ERR_IDENTIFIER_ALREADY_EXISTS
       ParseErrorMesssage = "Identifier already exists" + s1
 Case ERR_DUBLICATING_USER_IDENTIFIER
       ParseErrorMesssage = "Dublicating user identifier" + s1
 Case ERR_UNKNOWN_EXPRESSION
       ParseErrorMesssage = "Unknown expression" + s1
 Case ERR_UNKNOWN_FUNCTION
       ParseErrorMesssage = "Undefined function" + s1
 Case ERR_UNKNOWN_VARIABLE
       ParseErrorMesssage = "Undefined variable" + s1
 Case ERR_BAD_EXPONENTIAL_FORMAT
       ParseErrorMesssage = "Invalid exponent value" + s1
 Case ERR_SET_OriginalMathExpressionString_FALSE
       ParseErrorMesssage = "Set *OriginalMathExpressionString* to FALSE for differentiation or for Mathematica 4.1 export"
 Case ERR_MATH_EXPRESSION_WAS_ERASED
       ParseErrorMesssage = "Mathematical expression string was erased"
 Case ERR_USE_VerifySyntaxSemanticsAndDerivation
       ParseErrorMesssage = "Use *VerifySyntaxSemanticsAndDerivation* for differentiation"
 Case ERR_DERIVATIVE_EXPRESSION_WAS_ERASED
       ParseErrorMesssage = "Derivative expression string was erased"
 Case ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT
       ParseErrorMesssage = "Variable count and value caunt do not corespond"
 Case ERR_MATH_EXPRESSIONS_ARRAY
       ParseErrorMesssage = "Use *DoVectorOfMathExpressions* for calculate a vector of math expression"
 Case ERR_FUNCTION_NUMBER_MUST_BE_LESS
       ParseErrorMesssage = "Function number must be less" + s1
 Case ERR_FUNCTION_ADDRESS_CANNOT_BE_NIL
       ParseErrorMesssage = "Function address cannot be nil" + s1
 Case ERR_PROTECTED_EXPRESSION
       ParseErrorMesssage = "Cannot set value for protected expression" + s1
 Case ERR_DEF_FUNC_NAME
       ParseErrorMesssage = "Invalid function name" + s1
 Case ERR_DEF_FUNC_DUBLICATING
       ParseErrorMesssage = "Dublicating defined function" + s1
 Case ERR_DEF_FUNC_IMPLEMENTING
       ParseErrorMesssage = "Defined function was not implimented" + s1
 Case ERR_DEF_FUNC_ARG_COUNT
       ParseErrorMesssage = "Invalid arguments number for defined function" + s1
 Case ERR_DEF_FUNC_ARG_NAME
       ParseErrorMesssage = "Invalid argument name for defined function" + s1
 Case ERR_DEF_FUNC_ARG_DUBLICATING
       ParseErrorMesssage = "Dublicating argument name for defined function" + s1
 Case ERR_MULTIPLY
       ParseErrorMesssage = "Invalid value for *" + s1 + s
 Case ERR_DIVISION
       If MyObj.MathException(Item) = EX_ZeroDivide Then
        ParseErrorMesssage = "Division by 0"
       Else
        ParseErrorMesssage = "Invalid value for /" + s1 + s
       End If
 Case ERR_PLUS
       ParseErrorMesssage = "Invalid value for +" + s1 + s
 Case ERR_MINUS
       ParseErrorMesssage = "Invalid value for -" + s1 + s
 Case ERR_POWER
       ParseErrorMesssage = "Invalid value for ^" + s1 + s
 Case ERR_EQUAL
       ParseErrorMesssage = "Invalid value for =" + s1 + s
  Case Else
   If (MyObj.ErrorNumber(Item) >= 1) And (MyObj.ErrorNumber(Item) <= MyObj.BuiltInFunctionCount) Then
    If s = "" Then
      ParseErrorMesssage = "Invalid number of function arguments for: " + UCase(MyObj.BuiltInFunctionName(MyObj.ErrorNumber(Item)))
    Else
      ParseErrorMesssage = "Invalid value for " + UCase(MyObj.BuiltInFunctionName(MyObj.ErrorNumber(Item))) + s1 + s
    End If
   Else
    ParseErrorMesssage = MyObj.ErrorMessageInfo(Item)
   End If
End Select
End Function

Function ExecuteErrorMesssage(ByRef MyObj As Object, ByVal Item As Integer) As String
 Dim s, s1 As String, i As Integer

  i = InStr(MyObj.ErrorMessageInfo(Item), ":")
  If i > 0 Then
   s1 = " : " + Mid(MyObj.ErrorMessageInfo(Item), i + 1, Len(MyObj.ErrorMessageInfo(Item)) - i)
  Else
   s1 = ""
  End If
  If Len(s1) > 256 Then
   s1 = Mid(s1, 1, 256)
  End If
  s1 = LCase(s1)
  
  s = ""
  Select Case MyObj.MathException(Item)
   Case EX_NONMATH
       s = " : NONMATH"
   Case EX_Overflow
       s = " : Overflow"
   Case EX_Underflow
       s = " : Underflow"
   Case EX_InvalidArgument
       s = " : InvalidArgument"
   Case EX_ZeroDivide
       s = " : ZeroDivide"
   Case EX_InvalidOp
       s = " : InvalidOp"
  End Select

Select Case MyObj.ErrorNumber(Item)
 Case ERR_NO_MATH_EXPRESSION_WAS_PARSED
       ExecuteErrorMesssage = "No math expression was parsed"
 Case ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT
       ExecuteErrorMesssage = "Variable count and value caunt do not corespond"
 Case ERR_MATH_EXPRESSIONS_ARRAY
       ExecuteErrorMesssage = "Use *DoVectorOfMathExpressions* for calculate a vector of math expression"
 Case ERR_EXECUTE
       ExecuteErrorMesssage = "Execution error"
 Case ERR_DEF_FUNCTION_STACK_OVERFLOW
       ExecuteErrorMesssage = "Stack overflow" + s1
 Case ERR_SYSTEM_STACK_OVERFLOW
       ExecuteErrorMesssage = "Fatal error" + s1
 Case ERR_MULTIPLY
       ExecuteErrorMesssage = "Invalid value for *" + s1 + s
 Case ERR_DIVISION
       If MyObj.MathException(Item) = EX_ZeroDivide Then
        ExecuteErrorMesssage = "Division by 0"
       Else
        ExecuteErrorMesssage = "Invalid value for /" + s1 + s
       End If
 Case ERR_PLUS
       ExecuteErrorMesssage = "Invalid value for +" + s1 + s
 Case ERR_MINUS
       ExecuteErrorMesssage = "Invalid value for -" + s1 + s
 Case ERR_POWER
       ExecuteErrorMesssage = "Invalid value for ^" + s1 + s
 Case ERR_EQUAL
       ExecuteErrorMesssage = "Invalid value for =" + s1 + s
  Case Else
   If (MyObj.ErrorNumber(Item) >= 1) And (MyObj.ErrorNumber(Item) <= MyObj.BuiltInFunctionCount) Then
    If s = "" Then
      ExecuteErrorMesssage = "Invalid number of function arguments for: " + UCase(MyObj.BuiltInFunctionName(MyObj.ErrorNumber(Item)))
    Else
      ExecuteErrorMesssage = "Invalid value for " + UCase(MyObj.BuiltInFunctionName(MyObj.ErrorNumber(Item))) + s1 + s
    End If
   Else
    ExecuteErrorMesssage = MyObj.ErrorMessageInfo(Item)
   End If
End Select
End Function



